package org.mulesoft.apb.project.internal.instances

import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, Type}
import amf.shapes.client.scala.model.domain.SemanticContext
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDElementModel
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Management

object APIInstanceModel {

  val API_INSTANCE_TERM: ValueType        = Management + "APIInstance"
  val POLICY_BINDING_TERM: ValueType      = Management + "PolicyBinding"
  val ENVIRONMENT_TERM: ValueType         = Management + "Environment"
  val SERVICE_TERM: ValueType             = Management + "Service"
  val ENVIRONMENT_BINDING_TERM: ValueType = Management + "EnvironmentBinding"
  val EXTENSION_TERM: ValueType           = Management + "Extension"

  val POLICIES_FIELD_TERM: ValueType = Management + "policies"
  private val DEFAULT_BASE_IRI       = Namespace(SemanticContext.baseIri)
  val SPEC_FIELD_TERM                = Management + "spec"
  val METADATA_FIELD_TERM            = Management + "metadata"
  val METADATA_NAME_FIELD_TERM       = DEFAULT_BASE_IRI + "name"
  val SPEC_CLASS_TERM                = Management + "Spec"
  val TARGET_REF_FIELD_TERM          = Management + "targetRef"

  val PoliciesField = Field(
      Type.Array(JsonLDElementModel),
      Management + "policies",
      ModelDoc(
          displayName = "policies"
      )
  )
}
