package org.mulesoft.apb.project.client.platform

import amf.aml.client.scala.model.document.Dialect
import amf.apicontract.internal.convert.ApiClientConverters.ClientList
import amf.core.client.platform.resource.ResourceLoader
import amf.core.client.platform.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.internal.convert.CoreClientConverters.ClientMap
import amf.core.internal.convert.InternalClientMatcher
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency,
  ExtensionDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.platform.model.report.APBReport
import org.mulesoft.apb.project.client.scala.{
  DependencySet => InternalDependencySet,
  DependencySetResult => InternalDependencySetResult
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.JSExportAll
trait DependencySet {

  def design(): ClientList[DesignDependency]

  def validation(): ClientList[ProfileDependency]

  def designExtension(): ClientList[ExtensionDependency]

  def validationDialect(): Dialect

  def descriptor(): ProjectDescriptor

  def dependencyLoaders(): ClientMap[ResourceLoader]

  def allDependencies(): ClientList[ParsedDependency]

  def mainLoader(): ResourceLoader
}

@JSExportAll
case class DependencySetResult(override private[apb] val _internal: InternalDependencySetResult)
    extends APBReport(_internal) {
  def dependencySet(): DependencySet = DependencySetConverter.asClient(_internal.dependencySet)
}
