package org.mulesoft.apb.project.client.scala.extensions.environment

import amf.core.client.scala.model.StrField
import amf.core.client.scala.model.domain.DomainElement
import amf.core.internal.metamodel.Obj
import amf.core.internal.parser.domain.{Annotations, Fields}
import org.mulesoft.apb.project.internal.extensions.environment.InstanceEnvironmentModel
import org.mulesoft.apb.project.internal.extensions.environment.InstanceEnvironmentModel.{Id, Name, Type}

case class InstanceEnvironment private[apb] (fields: Fields, annotations: Annotations) extends DomainElement {
  override def meta: Obj = InstanceEnvironmentModel

  def environmentId(): StrField = fields.field(Id)
  def name(): StrField          = fields.field(Name)
  def `type`(): StrField        = fields.field(Type)

  def withEnvironmentId(value: String) = set(Id, value)
  def withName(value: String)          = set(Name, value)
  def withType(value: String)          = set(Type, value)

  override def componentId: String = environmentId().option().getOrElse("environment")
}

object InstanceEnvironment {
  def apply(): InstanceEnvironment = InstanceEnvironment(Fields(), Annotations())
}
