package org.mulesoft.apb.project.internal.convert

import amf.core.internal.convert.{BidirectionalMatcher, CoreBaseConverter}

trait ManagementBaseConverter
    extends CoreBaseConverter
    with APIInstanceConverter
    with PolicyBindingConverter
    with PolicyBindingRuleConverter
    with EnvironmentConverter
    with ServiceConverter
    with ServiceRouteConverter
    with TargetRefConverter

trait APIInstanceConverter {
  private type InternalAPIInstance = org.mulesoft.apb.project.client.scala.model.project.management.APIInstance
  private type ClientAPIInstance   = org.mulesoft.apb.project.client.platform.model.project.management.APIInstance
  implicit object APIInstanceConverter extends BidirectionalMatcher[InternalAPIInstance, ClientAPIInstance] {
    override def asClient(from: InternalAPIInstance): ClientAPIInstance   = new ClientAPIInstance(from)
    override def asInternal(from: ClientAPIInstance): InternalAPIInstance = from.internal
  }
}

trait PolicyBindingConverter {
  private type InternalPolicyBinding = org.mulesoft.apb.project.client.scala.model.project.management.PolicyBinding
  private type ClientPolicyBinding   = org.mulesoft.apb.project.client.platform.model.project.management.PolicyBinding
  implicit object PolicyBindingMatcher extends BidirectionalMatcher[InternalPolicyBinding, ClientPolicyBinding] {
    override def asClient(from: InternalPolicyBinding): ClientPolicyBinding   = new ClientPolicyBinding(from)
    override def asInternal(from: ClientPolicyBinding): InternalPolicyBinding = from.internal
  }
}

trait PolicyBindingRuleConverter {
  private type InternalPolicyBindingRule =
    org.mulesoft.apb.project.client.scala.model.project.management.PolicyBindingRule
  private type ClientPolicyBindingRule =
    org.mulesoft.apb.project.client.platform.model.project.management.PolicyBindingRule
  implicit object PolicyBindingRuleMatcher
      extends BidirectionalMatcher[InternalPolicyBindingRule, ClientPolicyBindingRule] {
    override def asClient(from: InternalPolicyBindingRule): ClientPolicyBindingRule = new ClientPolicyBindingRule(from)
    override def asInternal(from: ClientPolicyBindingRule): InternalPolicyBindingRule = from._internal
  }
}

trait EnvironmentConverter {
  private type InternalEnvironment = org.mulesoft.apb.project.client.scala.model.project.management.Environment
  private type ClientEnvironment   = org.mulesoft.apb.project.client.platform.model.project.management.Environment
  implicit object EnvironmentMatcher extends BidirectionalMatcher[InternalEnvironment, ClientEnvironment] {
    override def asClient(from: InternalEnvironment): ClientEnvironment   = new ClientEnvironment(from)
    override def asInternal(from: ClientEnvironment): InternalEnvironment = from.internal
  }
}

trait ServiceConverter {
  private type InternalService = org.mulesoft.apb.project.client.scala.model.project.management.Service
  private type ClientService   = org.mulesoft.apb.project.client.platform.model.project.management.Service
  implicit object ServiceMatcher extends BidirectionalMatcher[InternalService, ClientService] {
    override def asClient(from: InternalService): ClientService = new ClientService(from)

    override def asInternal(from: ClientService): InternalService = from.internal
  }
}

trait ServiceRouteConverter {
  private type InternalServiceRoute = org.mulesoft.apb.project.client.scala.model.project.management.ServiceRoute
  private type ClientServiceRoute   = org.mulesoft.apb.project.client.platform.model.project.management.ServiceRoute
  implicit object ServiceRouteMatcher extends BidirectionalMatcher[InternalServiceRoute, ClientServiceRoute] {
    override def asClient(from: InternalServiceRoute): ClientServiceRoute   = new ClientServiceRoute(from)
    override def asInternal(from: ClientServiceRoute): InternalServiceRoute = from._internal
  }
}

trait TargetRefConverter {
  private type InternalTargetRef = org.mulesoft.apb.project.client.scala.model.project.management.NamedRefWithKind
  private type ClientTargetRef   = org.mulesoft.apb.project.client.platform.model.project.management.TargetRef
  implicit object TargetRefMatcher extends BidirectionalMatcher[InternalTargetRef, ClientTargetRef] {
    override def asClient(from: InternalTargetRef): ClientTargetRef   = new ClientTargetRef(from)
    override def asInternal(from: ClientTargetRef): InternalTargetRef = from.internal
  }
}
