package org.mulesoft.apb.project.internal.engine

import org.mulesoft.apb.project.client.scala.model.descriptor.Gav

object MigrationRisks {
  val empty: MigrationRisks = MigrationRisks(Set.empty, Map.empty, Map.empty)
}

case class MigrationRisks(
    pathsToCheck: Set[String],
    firstMigrationRiskDetection: Map[String, Gav],
    allMigrationRiskDetections: Map[String, Set[Gav]]
) {

  def addGavForPath(path: String, gav: Gav): MigrationRisks = {
    firstMigrationRiskDetection.get(path) match {
      case Some(_) =>
        val newMigrationRisk = allMigrationRiskDetections.get(path) match {
          case Some(xs) => allMigrationRiskDetections + (path -> xs.+(gav))
          case None     => allMigrationRiskDetections + (path -> Set(gav))
        }
        copy(allMigrationRiskDetections = newMigrationRisk)
      case _ =>
        copy(firstMigrationRiskDetection = firstMigrationRiskDetection.updated(path, gav))
    }
  }

  def addGavForPaths(paths: Set[String], gav: Gav): MigrationRisks = {
    paths.foldLeft(this) { (acc, curr) =>
      acc.addGavForPath(curr, gav)
    }
  }

  def addPathsToCheck(files: Set[String], current: Gav): MigrationRisks = {
    val nextPaths = pathsToCheck ++ files
    files
      .foldLeft(this) { (acc, curr) =>
        acc.addGavForPath(curr, current)
      }
      .copy(pathsToCheck = nextPaths)
  }

  def addPathsToCheck(file: String, current: Gav): MigrationRisks = {
    val nextPaths = pathsToCheck + file
    addGavForPath(file, current).copy(pathsToCheck = nextPaths)
  }

  def add(risks: MigrationRisks): MigrationRisks = {
    val nextRisks = risks.allMigrationRiskDetections.foldLeft(allMigrationRiskDetections) { (acc, curr) =>
      val (path, gavList) = curr
      acc.get(path) match {
        case Some(list) => acc.updated(path, list ++ gavList)
        case None       => acc.updated(path, gavList)
      }
    }
    copy(
        this.pathsToCheck ++ risks.pathsToCheck,
        allMigrationRiskDetections = nextRisks,
        firstMigrationRiskDetection = firstMigrationRiskDetection ++ risks.firstMigrationRiskDetection
    )
  }
}
