package org.mulesoft.apb.project.client.scala.descriptor

import amf.core.client.common.validation.ValidationMode
import amf.core.client.scala.validation.{AMFValidationReport, AMFValidationResult}
import amf.core.internal.remote.Mimes
import amf.shapes.client.scala.ShapesConfiguration
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.model.report.{APBReport, APBResult}
import org.mulesoft.apb.project.internal.generated.DescriptorSchemaLoader
import org.mulesoft.apb.project.internal.parser.SyncJsonLdSchemaParser
import org.mulesoft.apb.project.internal.validations.ProjectValidations

object APBDescriptorParser {

  def parse(content: String): DescriptorParseResult = {
    val (obj, errors) = SyncJsonLdSchemaParser.parse(DescriptorSchemaLoader.doc, content)
    val syntaxResults =
      errors.map(_.copy(validationId = ProjectValidations.ProjectDescriptorSyntaxError.id)).map(APBResult.forGlobal)
    val modelResults = validate(content).map(APBResult.forGlobal)
    val descriptor   = ProjectDescriptor(obj)
    DescriptorParseResult(descriptor, syntaxResults ++ modelResults)
  }

  private def validate(content: String) = {
    ShapesConfiguration
      .predefined()
      .elementClient()
      .payloadValidatorFor(DescriptorSchemaLoader.schema, Mimes.`application/json`, ValidationMode.StrictValidationMode)
      .syncValidate(content)
      .results
      .distinct
      .map(_.copy(validationId = ProjectValidations.ProjectDescriptorModelError.id))
  }
}

case class DescriptorParseResult(descriptor: ProjectDescriptor, override val results: Seq[APBResult])
    extends APBReport(results)
