package org.mulesoft.apb.project.client.scala.descriptor

import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.internal.parser.DescriptorParserProviderCompanion

object DescriptorHandler extends DescriptorParserProviderCompanion {

  override def getHandler = new DescriptorHandler()

  override val descriptorFileName: String           = "exchange.json"
  override private[apb] val projectProtocol: String = "file:///"
}

case class DescriptorHandler() extends DescriptorParser with DescriptorRender {

  def parse(content: String): DescriptorParseResult = APBDescriptorParser.parse(content)

  def render(descriptor: ProjectDescriptor): String = APBDescriptorRender.render(descriptor)
}

trait DescriptorParser {
  def parse(content: String): DescriptorParseResult
}

trait DescriptorRender {
  def render(descriptor: ProjectDescriptor): String
}
