package org.mulesoft.apb.project.client.scala.model.project

import amf.core.client.scala.model.document.BaseUnit
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.{Documentation => DocumentationNode}
import org.mulesoft.apb.project.client.scala.model.project.management.APIInstance
import org.mulesoft.apb.project.internal.model.project.ProjectDocument

case class Project(private[apb] val document: ProjectDocument) {

  private[apb] def projectInfo: ProjectInfo   = document.encodes
  def apiContract(): BaseUnit                 = projectInfo.apiContract()
  def instances(): Seq[APIInstance]           = projectInfo.instances().map(obj => APIInstance(obj))
  def documentation(): Seq[DocumentationNode] = projectInfo.documentation().map(obj => DocumentationNode(obj))
}
