package org.mulesoft.apb.project.client.platform.model

import amf.core.client.platform.model.document.BaseUnit
import amf.shapes.client.platform.model.document.JsonLDInstanceDocument
import org.mulesoft.apb.project.client.platform.model.project.Project
import org.mulesoft.apb.project.client.platform.model.report.APBReport
import org.mulesoft.apb.project.client.scala.model.{
  BaseUnitBuildResult => InternalBaseUnitBuildResult,
  JsonLDInstanceDocumentBuildResult => InternalJsonLDInstanceDocumentBuildResult,
  ProjectBuildResult => InternalProjectBuildResult
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
@JSExportTopLevel("BaseUnitBuildResult")
case class BaseUnitBuildResult(override private[apb] val _internal: InternalBaseUnitBuildResult)
    extends APBReport(_internal) {
  def result(): BaseUnit = BaseUnitMatcher.asClient(_internal.result)
}

@JSExportAll
@JSExportTopLevel("ProjectBuildResult")
case class ProjectBuildResult(override private[apb] val _internal: InternalProjectBuildResult)
    extends APBReport(_internal) {
  def project(): Project = ProjectConverter.asClient(_internal.project)
}

@JSExportAll
@JSExportTopLevel("JsonLDInstanceDocumentBuildResult")
case class JsonLDInstanceDocumentBuildResult(
    override private[apb] val _internal: InternalJsonLDInstanceDocumentBuildResult
) extends APBReport(_internal) {
  def result(): JsonLDInstanceDocument = JsonLDInstanceDocumentMatcher.asClient(_internal.result)
}
