package org.mulesoft.apb.project.internal.instances.inline

import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{CONFIG, DESTINATION_REF, POLICY_REF, SPEC}
import org.mulesoft.apb.project.client.scala.model.project.management.{PolicyBinding, Service}
import org.mulesoft.apb.project.internal.instances.PolicyBindingIndex

case class InlineService(repo: PolicyBindingIndex) {

  def inlineInto(service: Service): Unit = {
    val policyBindings = repo.getBindingsFor(service)
    policyBindings.foreach(addServiceToBinding(_, service))
  }

  private def addServiceToBinding(binding: PolicyBinding, service: Service) = {
    binding.withService(service)
    binding.update(SPEC) { spec =>
      spec.update(CONFIG) { config =>
        config.graph.removeField(DESTINATION_REF)
      }
      spec.graph.removeField(POLICY_REF)
    }
  }
}
