package org.mulesoft.apb.project.internal.ops

import amf.core.internal.metamodel.{Field, Obj}
import amf.core.internal.parser.domain.Fields

object FieldsOps {

  def filter(fields: Fields, wanted: Set[Field]) = {
    fields.copy().filter { case (field, _) =>
      wanted.contains(field)
    }
  }

  def filter(fields: Fields, obj: Obj) = {
    val wanted = obj.fields.toSet
    fields.copy().filter { case (field, _) =>
      wanted.contains(field)
    }
  }
}
