package org.mulesoft.apb.project.internal.extensions.environment

import amf.core.client.scala.model.domain.AmfObject
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, ModelDefaultBuilder}
import org.mulesoft.apb.project.client.scala.extensions.environment.InstanceEnvironment
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Core, Management}

object InstanceEnvironmentModel extends ModelDefaultBuilder {

  val Id = Field(
      Str,
      Anypoint + "environmentID",
      doc("id")
  )

  val Name = Field(
      Str,
      Core + "name",
      doc("name")
  )

  val Type = Field(
      Str,
      Anypoint + "environmentType",
      doc("type")
  )

  override def modelInstance: AmfObject = InstanceEnvironment()

  override def fields: List[Field] = List(Id, Name, Type)

  override val `type`: scala.List[ValueType] = List(ValueType(Management, "Environment"))

  private def doc(name: String) = ModelDoc(displayName = name)
}
