package org.mulesoft.apb.project.client.scala.model.project.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{
  ALERTS,
  ENVIRONMENT,
  INSTANCE_ADDRESS,
  POLICIES,
  SPEC
}
import org.mulesoft.apb.project.internal.instances.APIInstanceModel.API_INSTANCE_TERM
import org.mulesoft.apb.project.internal.model.GraphAccessors

case class APIInstance(override private[apb] val internal: JsonLDObject)
    extends GraphAccessors
    with DynamicObject
    with HasName
    with HasMetadata
    with HasAnnotations
    with HasLabels
    with HasSpec {
  def withService(name: String, address: String): Service = withPolicyBinding().withService(name, address)

  def services: Seq[Service] = policyBindings.flatMap(pb => pb.serviceIfPresent)

  def address: String = {
    spec.getScalar[String](INSTANCE_ADDRESS)
  }

  def instanceId: Option[Int] = getLabelIfPresent[Int]("mulesoft.com/apiinstance-id")

  def instanceLabel: Option[String] = getLabelIfPresent[String]("mulesoft.com/apiinstance-label")

  def withAddress(address: String): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(INSTANCE_ADDRESS, address)
    }
    this
  }

  def alerts(): Seq[Alert] = spec.getObjectArray(ALERTS).map(Alert(_))

  def withAlerts(alerts: Seq[Alert]) = update(SPEC) { spec =>
    spec.withProperty(ALERTS, alerts)
  }

  def policyBindings: Seq[PolicyBinding] = {
    spec.getObjectArray(POLICIES).map(obj => PolicyBinding(obj.internal))
  }

  def withPolicyBinding(): PolicyBinding = {
    val policyBinding = PolicyBinding(name)
    update(SPEC) { spec =>
      spec.withProperty(POLICIES, policyBindings :+ policyBinding)
    }
    policyBinding
  }

  def withPolicyBindings(policies: Seq[PolicyBinding]): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(POLICIES, policyBindings ++ policies)
    }
    this
  }
  def environment: Environment = Environment(spec.getObject(ENVIRONMENT))

  def environmentOption: Option[Environment] =
    specIfPresent.flatMap(_.getObjectIfPresent(ENVIRONMENT)).map(Environment(_))

  def withEnvironment(name: String): Environment = {
    val environment = Environment(name)
    update(SPEC) { spec =>
      spec.withProperty(ENVIRONMENT, environment)
    }
    environment
  }
}

object APIInstance {
  def apply(name: String, address: String): APIInstance = {
    val path  = JsonPath.empty
    val model = JsonLDEntityModel(List(API_INSTANCE_TERM), Nil, path)
    val init  = JsonLDObject.empty(model, path)
    APIInstance(init)
      .withProperty("http://a.ml/vocabularies/core#apiVersion", Constants.apiVersion)
      .withProperty("http://a.ml/vocabularies/core#kind", Constants.apiInstanceKind)
      .withName(name)
      .withAddress(address)
  }

  private[apb] def apply(internal: JsonLDObject) = new APIInstance(internal)
}
