package org.mulesoft.apb.project.internal.dependency.config

import amf.apicontract.client.scala._
import amf.core.internal.remote.Spec
import amf.graphql.client.scala.GraphQLConfiguration
import amf.graphqlfederation.client.scala.GraphQLFederationConfiguration
import amf.grpc.client.scala.GRPCConfiguration
import amf.shapes.client.scala.config.JsonSchemaConfiguration
import org.mulesoft.apb.project.internal.common.Classifier

object ConfigProvider {

  def fromClassifier(classifier: String): AMFConfiguration = classifier match {
    case Classifier.RAML | Classifier.OAS | Classifier.ASYNC => APIConfiguration.API()
    case Classifier.GRAPHQL                                  => GraphQLConfiguration.GraphQL()
    case Classifier.GRAPHQL_APOLLO                           => GraphQLFederationConfiguration.GraphQLFederation()
    case Classifier.GRPC                                     => GRPCConfiguration.GRPC()
    case Classifier.JSON_SCHEMA   => ConfigurationAdapter.adapt(JsonSchemaConfiguration.JsonSchema())
    case Classifier.OAS_COMPONENT => OASConfiguration.OASComponent()
    case _                        => APIConfiguration.API()
  }

  def fromSpec(spec: Spec): AMFConfiguration = spec match {
    case Spec.RAML08 => RAMLConfiguration.RAML08()
    case Spec.RAML10 => RAMLConfiguration.RAML10()
    case Spec.OAS20  => OASConfiguration.OAS20()
    case Spec.OAS30  => OASConfiguration.OAS30()
    case Spec.ASYNC20 | Spec.ASYNC21 | Spec.ASYNC22 | Spec.ASYNC23 | Spec.ASYNC24 | Spec.ASYNC25 | Spec.ASYNC26 =>
      AsyncAPIConfiguration.Async20()
    case Spec.JSONSCHEMA         => ConfigurationAdapter.adapt(JsonSchemaConfiguration.JsonSchema())
    case Spec.GRAPHQL            => GraphQLConfiguration.GraphQL()
    case Spec.GRAPHQL_FEDERATION => GraphQLFederationConfiguration.GraphQLFederation()
    case Spec.GRPC               => GRPCConfiguration.GRPC()
    case _ =>
      throw UnrecognizedSpecException(
        s"Spec ${spec.id} not supported. Supported specs are ${Spec.RAML08.id}, ${Spec.RAML10.id}, ${Spec.OAS20.id}, ${Spec.OAS30.id}, ${Spec.ASYNC20.id}, ${Spec.JSONSCHEMA.id}, ${Spec.GRAPHQL.id}, ${Spec.GRAPHQL_FEDERATION.id}, ${Spec.GRPC.id}"
      )
  }
}
