package org.mulesoft.apb.project.internal.view

import amf.aml.client.scala.model.document.{DialectInstance, DialectInstanceProcessingData}
import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.adoption.IdAdopter
import amf.core.client.scala.config.RenderOptions
import amf.core.client.scala.model.domain.{AmfObject, DomainElement}
import amf.core.client.scala.vocabulary.{Namespace, NamespaceAliases}
import amf.core.internal.metamodel.document.FragmentModel
import amf.core.internal.remote.Mimes.`application/ld+json`
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces._

case class DialectInstanceView(schemaId: String, inner: ModelView[AmfObject]) extends ModelView[String] {

  private val schemaBase = s"$schemaId#/declarations/"

  private val aliases = Map(
      "api"        -> Api,
      "catalog"    -> Catalog,
      "anypoint"   -> Anypoint,
      "management" -> Management,
      "contract"   -> Contract,
      "schema"     -> Namespace(schemaBase)
  )

  override def view(element: AmfObject): String = {
    val encodes  = inner.view(element)
    val instance = createContainerInstance(schemaId)
    adopt(instance)
    instance.setWithoutId(FragmentModel.Encodes, encodes)
    toJsonLd(instance)
  }

  private def adopt(instance: DialectInstance): Unit = {
    new IdAdopter("").adoptFromRoot(instance)
  }

  private def toJsonLd(instance: DialectInstance): String = {
    val client = AMFGraphConfiguration
      .predefined()
      .withRenderOptions(RenderOptions().withPrettyPrint.withCompactUris)
      .withAliases(NamespaceAliases.withCustomAliases(aliases))
      .baseUnitClient()
    client.render(instance, `application/ld+json`)
  }

  private def createContainerInstance(schemaId: String) = {
    DialectInstance()
      .withRoot(true)
      .withProcessingData(
          DialectInstanceProcessingData()
            .withTransformed(false)
            .withDefinedBy(schemaId)
            .withSourceSpec("APIProject 0.1")
      )
  }

}
