package org.mulesoft.apb.project.client.platform.model.descriptor.community

import amf.apicontract.internal.convert.ApiClientConverters.ClientOption
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{Community => InternalCommunity}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class Community private[apb] (override private[apb] val _internal: InternalCommunity)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("Community")
  def this(portal: String, target: PortalTarget, visibility: ClientList[String]) =
    this(InternalCommunity(portal, target._internal, visibility.asInternal))

  def portal(): String                 = _internal.portal
  def version(): ClientOption[String]  = _internal.version.asClient
  def visibility(): ClientList[String] = _internal.visibility.asClient
  def target(): PortalTarget           = _internal.target

  def withPortal(portal: String): Community = {
    _internal.withPortal(portal)
    this
  }

  def withVersion(version: String): Community = {
    _internal.withVersion(version)
    this
  }

  def withVisibility(visibility: ClientList[String]): Community = {
    _internal.withVisibility(visibility.asInternal)
    this
  }

  def withTarget(target: PortalTarget): Community = {
    _internal.withTarget(target)
    this
  }
}
