package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.extensions.EnvironmentExtension
import org.mulesoft.apb.project.client.scala.model.project.management.APIInstance
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}
import org.yaml.model.YNode

class ProjectSummaryInstanceEmitter(instance: APIInstance) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      instance.instanceId.foreach(id => entryBuilder.entry(YNode("id"), YNode(id)))
      instance.instanceLabel.foreach(id => entryBuilder.entry(YNode("label"), YNode(id)))

      EnvironmentExtension.extractFromInstance(instance).map { environment =>
        entryBuilder.entry(
            YNode("environment"),
            partBuilder => ProjectSummaryEnvironmentEmitter(environment).emit(partBuilder)
        )
      }
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryInstanceEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryInstanceEmitter(APIInstance(instance))
}
