package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{PortalTarget, PortalTargetModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.{emitScalarField}
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryPortalTargetEmitter(target: PortalTarget) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, target, PortalTargetModel.Portal)
      emitScalarField(entryBuilder, target, PortalTargetModel.Organization)
      emitScalarField(entryBuilder, target, PortalTargetModel.Environment)
      emitScalarField(entryBuilder, target, PortalTargetModel.Domain)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryPortalTargetEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryPortalTargetEmitter(PortalTarget(instance))
}
