package org.mulesoft.apb.project.client.platform.model.descriptor

import amf.apicontract.internal.convert.ApiClientConverters.ClientOption
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.{Metadata => InternalMetadata}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class Metadata private[apb] (override private[apb] val _internal: InternalMetadata)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("MetadataElement")
  def this() = this(InternalMetadata())

  def branchId(): ClientOption[String]  = _internal.branchId.asClient
  def commitId(): ClientOption[String]  = _internal.commitId.asClient
  def projectId(): ClientOption[String] = _internal.projectId.asClient

  def withBranchId(branchId: String): Metadata = {
    _internal.withBranchId(branchId)
    this
  }
  def withCommitId(commitId: String): Metadata = {
    _internal.withCommitId(commitId)
    this
  }
  def withProjectId(projectId: String): Metadata = {
    _internal.withProjectId(projectId)
    this
  }
}
