package org.mulesoft.apb.project.client.scala.model.descriptor.community

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.{Field, Type}
import amf.core.internal.metamodel.Type.{Int, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.CommunityModel.{
  Portal,
  Target,
  Version,
  Visibility,
  entityModel
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{ApiCommunity, Catalog, Core}
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}

import scala.language.implicitConversions

class Community(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {
  override type This = Community

  private implicit def targetConversion(jsonLDObject: JsonLDObject): PortalTarget = PortalTarget.apply(jsonLDObject)

  override protected def fields: Fields = internal.fields

  def portal: String          = get[StrField](Portal)
  def version: Option[String] = get[StrField](Version)
  def visibility: Seq[String] = get[Seq[StrField]](Visibility)
  def target: PortalTarget    = get[JsonLDObject](Target)

  def withPortal(portal: String): this.type = {
    internal.withProperty(Portal, portal)
    this
  }
  def withVersion(version: String): this.type = {
    internal.withProperty(Version, version)
    this
  }
  def withVisibility(visibility: Seq[String]): this.type = {
    internal.withStringPropertyCollection(Visibility, visibility)
    this
  }
  def withTarget(target: PortalTarget): this.type = {
    internal.withProperty(Target, target)
    this
  }
}

object Community {
  def apply(portal: String, target: PortalTarget, visibility: Seq[String] = Seq()): Community =
    Community
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withPortal(portal)
      .withTarget(target)
      .withVisibility(visibility)

  private[apb] def apply(jsonLDObject: JsonLDObject): Community = new Community(jsonLDObject)
}

trait CommunityModel {
  val Portal: Field = Field(Str, ApiCommunity + "portal", doc("portal"))

  val Target: Field = Field(JsonLDElementModel, ApiCommunity + "target", doc("target"))

  val Version: Field = Field(Str, Catalog + "version", doc("version"))

  val Visibility: Field = Field(Type.Array(Str), ApiCommunity + "visibility", doc("visibility"))

  def `type`: List[ValueType] = List(ApiCommunity + "Community")
  def fields: List[Field]     = List(Portal, Target, Version, Visibility)

  protected def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object CommunityModel extends CommunityModel
