package org.mulesoft.apb.project.client.platform.model.descriptor

import amf.apicontract.internal.convert.ApiClientConverters.{ClientList, ClientOption}
import org.mulesoft.apb.project.client.platform.model.descriptor.documentation.Documentation
import org.mulesoft.apb.project.client.platform.model.descriptor.community.Community
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.{ProjectDescriptor => InternalProjectDescriptor}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.common.time.SimpleDateTime

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class ProjectDescriptor private[apb] (override private[apb] val _internal: InternalProjectDescriptor)
    extends DynamicObject(_internal) {

  def this(main: String) = this(InternalProjectDescriptor(main))
  @JSExportTopLevel("ProjectDescriptor")
  def this() = this(InternalProjectDescriptor())

  def main(): ClientOption[String]                  = _internal.main.asClient
  def name(): String                                = _internal.name()
  def gav(): Gav                                    = _internal.gav()
  def classifier(): ClientOption[String]            = _internal.classifier().asClient
  def tags(): ClientList[String]                    = _internal.tags().asClient
  def apiVersion(): ClientOption[String]            = _internal.apiVersion().asClient
  def organizationId(): ClientOption[String]        = _internal.organizationId().asClient
  def originalFormatVersion(): ClientOption[String] = _internal.originalFormatVersion.asClient
  def metadata(): ClientOption[Metadata]            = _internal.metadata.asClient
  def backwardsCompatible(): ClientOption[Boolean]  = _internal.backwardsCompatible.asClient
  def publishWithRefFiles(): ClientOption[Boolean]  = _internal.publishWithRefFiles.asClient
  def description(): ClientOption[String]           = _internal.description.asClient
  def projectId(): ClientOption[String]             = _internal.projectId.asClient
  def dependencies(): ClientList[ProjectDependency] = _internal.dependencies().asClient
  def descriptorVersion(): String                   = _internal.descriptorVersion
  def instances(): ClientList[Instance]             = _internal.instances.asClient
  def status(): ClientOption[String]                = _internal.status().asClient
  def createdAt(): ClientOption[String]             = _internal.createdAt().map(_.toString).asClient
  def createdBy(): ClientOption[String]             = _internal.createdBy().asClient
  def updatedAt(): ClientOption[String]             = _internal.updatedAt().map(_.toString).asClient
  def customFields(): ClientList[String]            = _internal.customFields().asClient
  def keyValueTags(): ClientList[String]            = _internal.keyValueTags().asClient
  def tenantId(): ClientOption[String]              = _internal.tenantId().asClient
  def categories(): ClientList[String]              = _internal.categories().asClient
  def `()type`: ClientOption[String]                = _internal.`type`().asClient
  def majorVersionComponent(): ClientOption[Int]    = _internal.majorVersionComponent().asClient
  def minorVersionComponent(): ClientOption[Int]    = _internal.minorVersionComponent().asClient
  def patchVersionComponent(): ClientOption[Int]    = _internal.patchVersionComponent().asClient
  def documentation(): ClientList[Documentation]    = _internal.documentation.asClient
  def apiId(): ClientOption[String]                 = _internal.apiId().asClient
  def projectType(): ClientOption[String]           = _internal.projectType().asClient
  def contactName(): ClientOption[String]           = _internal.contactName().asClient
  def contactEMail(): ClientOption[String]          = _internal.contactEMail().asClient

  def isLegacyDescriptor(): Boolean = _internal.isLegacyDescriptor

  def withMain(main: String): ProjectDescriptor = _internal.withMain(main)

  def withDependency(dependency: ProjectDependency): ProjectDescriptor = _internal.withDependency(dependency)

  def withInstance(instance: Instance): ProjectDescriptor = _internal.withInstance(instance)

  def withInstances(instances: ClientList[Instance]): ProjectDescriptor = _internal.withInstances(instances.asInternal)

  def withName(name: String): ProjectDescriptor = _internal.withName(name)

  def withDescriptorVersion(version: String): ProjectDescriptor = _internal.withDescriptorVersion(version)

  def withGav(gav: Gav): ProjectDescriptor = _internal.withGav(gav)

  def withVersion(version: String): ProjectDescriptor       = _internal.withVersion(version)
  def withClassifier(classifier: String): ProjectDescriptor = _internal.withClassifier(classifier)

  def withTags(tags: ClientList[String]): ProjectDescriptor = _internal.withTags(tags.asInternal)

  def withTag(tag: String): ProjectDescriptor = _internal.withTag(tag)

  def withApiVersion(apiVersion: String): ProjectDescriptor = _internal.withApiVersion(apiVersion)

  def withOrganizationId(organizationId: String): ProjectDescriptor = _internal.withOrganizationId(organizationId)

  def withOriginalFormatVersion(originalFormatVersion: String): ProjectDescriptor =
    _internal.withOriginalFormatVersion(originalFormatVersion)

  def withMetadata(metadata: Metadata): ProjectDescriptor = _internal.withMetadata(metadata)

  def withBackwardsCompatible(value: Boolean): ProjectDescriptor = _internal.withBackwardsCompatible(value)

  def withPublishWithRefFiles(value: Boolean): ProjectDescriptor = _internal.withPublishWithRefFiles(value)

  def withDescription(description: String): ProjectDescriptor = _internal.withDescription(description)

  def withProjectId(projectId: String): ProjectDescriptor = _internal.withProjectId(projectId)

  def withStatus(status: String): ProjectDescriptor = _internal.withStatus(status)

  def withCreatedAt(createdAt: String): ProjectDescriptor = {
    val maybeDateTime = SimpleDateTime.unapply(createdAt)
    maybeDateTime.fold(_internal) { value => _internal.withCreatedAt(value) }
  }

  def withUpdatedAt(updatedAt: String): ProjectDescriptor = {
    val maybeDateTime = SimpleDateTime.unapply(updatedAt)
    maybeDateTime.fold(_internal) { value => _internal.withUpdatedAt(value) }
  }

  def withCreatedBy(createdBy: String): ProjectDescriptor = _internal.withCreatedBy(createdBy)

  def withTenantId(tenantId: String): ProjectDescriptor = _internal.withTenantId(tenantId)

  def withCategories(categories: ClientList[String]): ProjectDescriptor =
    _internal.withCategories(categories.asInternal)

  def withFields(fields: ClientList[String]): ProjectDescriptor = _internal.withFields(fields.asInternal)

  def withKeyValueTags(keyValueTags: ClientList[String]): ProjectDescriptor =
    _internal.withKeyValueTags(keyValueTags.asInternal)

  def withType(`type`: String): ProjectDescriptor = _internal.withType(`type`)

  def withMajorVersionComponent(version: Int): ProjectDescriptor = _internal.withMajorVersionComponent(version)

  def withMinorVersionComponent(version: Int): ProjectDescriptor = _internal.withMinorVersionComponent(version)

  def withPatchVersionComponent(version: Int): ProjectDescriptor = _internal.withPatchVersionComponent(version)
  def withApiId(apiId: String): ProjectDescriptor                = _internal.withApiId(apiId)
  def withProjectType(projectType: String): ProjectDescriptor    = _internal.withProjectType(projectType)

  def withDocumentation(documentation: Documentation): ProjectDescriptor = {
    _internal.withDocumentation(documentation)
    this
  }

  def withDocumentation(documentations: ClientList[Documentation]): ProjectDescriptor = {
    _internal.withDocumentation(documentations.asInternal)
    this
  }

  def withCommunity(community: Community): ProjectDescriptor = {
    _internal.withCommunity(community)
    this
  }

  def withCommunities(communities: ClientList[Community]): ProjectDescriptor = {
    _internal.withCommunities(communities.asInternal)
    this
  }
}
