package org.mulesoft.apb.project.client.platform.model.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.management.{Environment => InternalEnvironment}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class Environment(override private[apb] val internal: InternalEnvironment)
    extends DynamicObject(internal)
    with HasAnnotations
    with HasName {

  @JSExportTopLevel("Environment")
  def this(name: String) = this(InternalEnvironment(name))

  def namespace: String = internal.namespace

  def withNamespace(namespace: String): this.type = {
    internal.withNamespace(namespace)
    this
  }

  def kind: String = internal.kind

  def withKind(kind: String): this.type = {
    internal.withKind(kind)
    this
  }
}
