package org.mulesoft.apb.project.client.platform.model.descriptor

import amf.apicontract.internal.convert.ApiClientConverters.ClientOption
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.{Instance => InternalInstance}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class Instance(override private[apb] val _internal: InternalInstance) extends DynamicObject(_internal) {

  @JSExportTopLevel("Instance")
  def this(gcl: String) = this(InternalInstance(gcl))

  def gcl(): String                  = _internal.gcl
  def schema(): ClientOption[String] = _internal.definedBy.asClient

  def dependencies(): ClientList[ProjectDependency] = _internal.dependencies.asClient

  def withDependencies(dependencies: ClientList[ProjectDependency]): Instance = {
    _internal.withDependencies(dependencies.asInternal)
    this
  }
}
