package org.mulesoft.apb.project.client.scala.model.descriptor

object Gav {
  def unapply(gav: String): Option[Gav] = gav.split("/") match {
    case Array(group, asset, version) => Some(Gav(group, asset, version))
    case _                            => None
  }
}

case class Gav(groupId: String, assetId: String, version: String) {
  def path(): String = s"$groupId/$assetId/$version/"
}
