package org.mulesoft.apb.project.internal.emitter

import org.mulesoft.apb.project.client.scala.model.project.ProjectInfo
import org.mulesoft.apb.project.internal.emitter.EmitterUtils._
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel.{Contract, Instances}
import org.mulesoft.apb.project.internal.model.ProjectDescriptorModel._
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel.{AssetId, Classifier, GroupId, Version}
import org.yaml.model.YDocument
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryEmitter(project: ProjectInfo) {
  def emit(): YDocument = {
    YDocument { partBuilder: PartBuilder =>
      partBuilder.obj { objBuilder: EntryBuilder =>
        emitTo(objBuilder)
      }
    }
  }

  private def emitTo(entryBuilder: EntryBuilder): Unit = {

    emitScalarField(entryBuilder, project, ApiId)
    emitScalarField(entryBuilder, project, ApiVersion)
    emitScalarField(entryBuilder, project, ProjectType)
    emitScalarField(entryBuilder, project, TenantId)
    emitScalarField(entryBuilder, project, OrganizationId)
    emitScalarField(entryBuilder, project, GroupId)
    emitScalarField(entryBuilder, project, AssetId)
    emitScalarField(entryBuilder, project, Version)
    emitScalarField(entryBuilder, project, Name)
    emitScalarField(entryBuilder, project, Status)
    emitScalarField(entryBuilder, project, CreatedBy)
    emitScalarField(entryBuilder, project, CreatedAt)
    emitScalarField(entryBuilder, project, UpdatedAt)
    emitScalarField(
        entryBuilder,
        project,
        UpdatedAt,
        nameOverride = Some("systemUpdatedAt")
    ) // ToDo: Create a field for this

    emitObjectArrayField(entryBuilder, project, Dependencies) { dependency =>
      ProjectSummaryDependencyEmitter(dependency)
    }

    emitScalarArrayField(entryBuilder, project, Tags)
    emitScalarArrayField(entryBuilder, project, KeyValueTags)
    emitScalarArrayField(entryBuilder, project, Categories)
    emitScalarArrayField(entryBuilder, project, CustomFields)

    emitScalarField(entryBuilder, project, Classifier)
    emitScalarField(entryBuilder, project, TypeField)

    emitJsonLdObjectArray(entryBuilder, project, Instances, nameOverride = Some("instances")) { instance =>
      ProjectSummaryInstanceEmitter(instance)
    }
    emitBaseUnitField(entryBuilder, project, Contract, nameOverride = Some("contract")) { contractDocument =>
      ProjectSummaryContractEmitter(contractDocument)
    }
    emitJsonLdObjectArray(entryBuilder, project, Communities) { community =>
      ProjectSummaryCommunityEmitter(community)
    }

  }
}
