package org.mulesoft.apb.project.client.platform.parser

import amf.core.client.platform.resource.ResourceLoader
import amf.core.client.scala.resource.{ResourceLoader => InternalResourceLoader}
import org.mulesoft.apb.project.client.platform.model.project.ProjectInfo
import org.mulesoft.apb.project.client.scala.parser.{
  ApiSummaryJsonLdPartialParser => InternalApiSummaryJsonLdPartialParser
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.concurrent.ExecutionContext.Implicits.global

class ApiSummaryJsonLdPartialParser(resourceLoaders: ClientList[ResourceLoader]) {
  private val internalResourceLoaders: Seq[InternalResourceLoader] = resourceLoaders.asInternal
  val inner = new InternalApiSummaryJsonLdPartialParser(internalResourceLoaders.toList)

  def parse(uri: String): ClientFuture[ProjectInfo] = inner.parse(uri).asClient
}
