package org.mulesoft.apb.project.internal.model.descriptor

import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.{Bool, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Catalog}

object ProjectDependencyModel {

  val GroupId    = Field(Str, Catalog + "groupId", doc("groupId"))
  val AssetId    = Field(Str, Catalog + "assetId", doc("assetId"))
  val Version    = Field(Str, Catalog + "semverVersion", doc("version"))
  val Scope      = Field(Str, Anypoint + "scope", doc("scope"))
  val Classifier = Field(Str, Catalog + "classifier", doc("classifier"))
  val Packaging  = Field(Str, Catalog + "packaging", doc("packaging"))
  val Provided   = Field(Bool, Anypoint + "provided", doc("provided"))

  val `type`: List[ValueType] = List(Catalog + "Version")

  private def doc(name: String) = ModelDoc(displayName = name)

  val fields: List[Field] = List(GroupId, AssetId, Version, Scope, Provided)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}
