package org.mulesoft.apb.project.internal.render.plugin

import amf.core.client.common.{NormalPriority, PluginPriority}
import amf.core.client.scala.errorhandling.AMFErrorHandler
import amf.core.client.scala.model.document.BaseUnit
import amf.core.internal.plugins.render.{RenderConfiguration, RenderInfo, SYAMLBasedRenderPlugin}
import amf.core.internal.remote.Mimes.`application/json`
import org.mulesoft.apb.project.internal.emitter.ProjectSummaryEmitter
import org.mulesoft.apb.project.internal.model.project.ProjectDocument
import org.yaml.model.YDocument

object ProjectSummaryRenderPlugin extends SYAMLBasedRenderPlugin {

  override protected def unparseAsYDocument(
      unit: BaseUnit,
      renderConfig: RenderConfiguration,
      errorHandler: AMFErrorHandler
  ): Option[YDocument] = unit match {
    case document: ProjectDocument => Some(new ProjectSummaryEmitter(document.encodes).emit())
    case _                         => None
  }

  override def defaultSyntax(): String = `application/json`

  override val id: String = s"api-project-parsing-plugin"

  override def applies(element: RenderInfo): Boolean = element.unit match {
    case _: ProjectDocument => true
    case _                  => false
  }

  override def priority: PluginPriority = NormalPriority
}
