package org.mulesoft.apb.project.client.platform.model.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject

import scala.scalajs.js.annotation.JSExportAll
import org.mulesoft.apb.project.client.scala.model.management.{Service => InternalService}
import org.mulesoft.apb.project.internal.convert.ManagementClientConverters._
@JSExportAll
class Service(override private[apb] val internal: InternalService) extends DynamicObject(internal) {

  def name: String = internal.name

  def address: String = internal.address

  def withAddress(address: String): this.type = {
    internal.withAddress(address)
    this
  }

  def routes: ClientList[ServiceRoute] = internal.routes.asClient

  def withRoute(destinationPath: String): ServiceRoute = internal.withRoute(destinationPath)
}
