package org.mulesoft.apb.project.internal.transformation

import amf.core.client.scala.transform.{TransformationPipeline, TransformationStep}
import org.mulesoft.apb.project.client.scala.{DependencySet, ProjectConfiguration}

case class APBTransformationPipeline(config: DependencySet, base: TransformationPipeline)
    extends TransformationPipeline {
  override val name: String = base.name

  override def steps: Seq[TransformationStep] = getApbSteps(config) ++ base.steps

  private def getApbSteps(config: DependencySet): Seq[TransformationStep] = {
    val base = Seq(new JSONDocumentRefCleaningTransformationStage())
    if (config.descriptor().isRaml)
      base ++ Seq(
        new CompanionLibCheckTransformationStage(fetchExtensionCompanions(config)),
        new AdoptionDependantCallsFixingTransformationStage
      )
    else base
  }

  private def fetchExtensionCompanions(config: DependencySet) = config
    .designExtension()
    .flatMap(_.companionLibDependency())
}
