package org.mulesoft.apb.project.client.scala.model.descriptor.community

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.{Int, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.PortalTargetModel.{
  Domain,
  Environment,
  Organization,
  Network,
  entityModel
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.ApiCommunity
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}

class PortalTarget(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {
  override type This = PortalTarget

  override protected def fields: Fields = internal.fields

  def network: String      = get[StrField](Network)
  def organization: String = get[StrField](Organization)
  def domain: String       = get[StrField](Domain)
  def environment: String  = get[StrField](Environment)

  def withNetwork(network: String): this.type = {
    internal.withProperty(Network, network)
    this
  }

  def withOrganization(organization: String): this.type = {
    internal.withProperty(Organization, organization)
    this
  }

  def withDomain(domain: String): this.type = {
    internal.withProperty(Domain, domain)
    this
  }

  def withEnvironment(environment: String): this.type = {
    internal.withProperty(Environment, environment)
    this
  }
}

object PortalTarget {
  def apply(network: String, organization: String, domain: String, environment: String): PortalTarget =
    PortalTarget
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withNetwork(network)
      .withOrganization(organization)
      .withDomain(domain)
      .withEnvironment(environment)

  private[apb] def apply(jsonLDObject: JsonLDObject): PortalTarget = new PortalTarget(jsonLDObject)
}

trait PortalTargetModel {
  val Network: Field = Field(Str, ApiCommunity + "network", doc("network"))

  val Organization: Field = Field(Str, ApiCommunity + "organization", doc("organization"))

  val Environment: Field = Field(Str, ApiCommunity + "environment", doc("environment"))

  val Domain: Field = Field(Str, ApiCommunity + "domain", doc("domain"))

  def `type`: List[ValueType] = List(ApiCommunity + "PortalTarget")
  def fields: List[Field]     = List(Network, Organization, Environment, Domain)

  protected def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object PortalTargetModel extends PortalTargetModel
