package org.mulesoft.apb.project.client.platform.model.project

import amf.core.client.platform.model.document.BaseUnit
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.platform.model.descriptor.Gav
import org.mulesoft.apb.project.client.scala.model.project.{ProjectInfo => InternalProjectInfo}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.common.time.SimpleDateTime

class ProjectInfo(private[apb] val _internal: InternalProjectInfo) {

  def this() = this(InternalProjectInfo())

  def apiContract(): BaseUnit = _internal.apiContract()
  def instances(): ClientList[JsonLDObject] = {
    new InternalSeqOps(_internal.instances())(new IdentityMatcher[JsonLDObject] {}).asClient
  }

  val tenantId: ClientOption[String]                 = _internal.tenantId().asClient
  val organizationId: ClientOption[String]           = _internal.organizationId().asClient
  val gav: Gav                                       = _internal.gav()
  val apiVersion: ClientOption[String]               = _internal.apiVersion().asClient
  val updatedAt: ClientOption[SimpleDateTime]        = _internal.updatedAt().asClient
  val systemUpdateTime: ClientOption[SimpleDateTime] = _internal.systemUpdateTime().asClient
  val projectETag: ClientOption[String]              = _internal.projectETag().asClient
}
