package org.mulesoft.apb.project.client.scala.model

import amf.core.client.scala.vocabulary.Namespace
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject

trait DynamicObject {
  type This <: DynamicObject

  private[apb] val internal: JsonLDObject
  private val namespace: Namespace = Namespace("http://anypoint.apb/vocabularies/dynamic#")

  def withDynamicProperty(key: String, value: String): This = {
    internal.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: Int): This = {
    internal.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: Boolean): This = {
    internal.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: Float): This = {
    internal.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }

  def withDynamicProperty(key: String, value: JsonLDObject): This = {
    internal.withProperty((namespace + key).iri(), value)
    this.asInstanceOf[This]
  }
}
