package org.mulesoft.apb.project.client.scala.model.descriptor.governance

import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.GovernanceInfoModel.entityModel
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Governance
import org.mulesoft.apb.project.internal.jsonld.JsonLDPathGenerator
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.GovernanceInfoModel.{Managed, Unmanaged}

class GovernanceInfo(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = GovernanceInfo

  override protected def fields: Fields = internal.fields

  private implicit def targetConversion(jsonLDObject: JsonLDObject): ValidationGroup =
    ValidationGroup.apply(jsonLDObject)

  def managed: ValidationGroup   = get[JsonLDObject](Managed)
  def unmanaged: ValidationGroup = get[JsonLDObject](Unmanaged)

  def withManaged(validationGroup: ValidationGroup): this.type = {
    val jsonLDObject = JsonLDPathGenerator.jsonLDObjectPath(validationGroup.internal, Managed)
    internal.set(Managed, jsonLDObject)
    this
  }

  def withUnmanaged(validationGroup: ValidationGroup): this.type = {
    val jsonLDObject = JsonLDPathGenerator.jsonLDObjectPath(validationGroup.internal, Unmanaged)
    internal.set(Unmanaged, jsonLDObject)
    this
  }

}

object GovernanceInfo {
  def apply(managed: ValidationGroup, unmanaged: ValidationGroup): GovernanceInfo = GovernanceInfo
    .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
    .withManaged(managed)
    .withUnmanaged(unmanaged)
  private[apb] def apply(jsonLDObject: JsonLDObject): GovernanceInfo = new GovernanceInfo(jsonLDObject)

}

trait GovernanceInfoModel {
  val Managed: Field   = Field(JsonLDElementModel, Governance + "managed", doc("managed"))
  val Unmanaged: Field = Field(JsonLDElementModel, Governance + "unmanaged", doc("unmanaged"))

  val `type`: List[ValueType] = List(Governance + "GovernanceInfo")
  val fields: List[Field]     = List(Managed, Unmanaged)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
  protected def doc(name: String)    = ModelDoc(displayName = name)

}
object GovernanceInfoModel extends GovernanceInfoModel
