package org.mulesoft.apb.project.internal.instances

case class ResourceVersion private (version: String)

object ResourceVersion {
  val gatewayV1Alpha1: ResourceVersion    = ResourceVersion("gateway.mulesoft.com/v1alpha1")
  val gatewayV1Beta1: ResourceVersion     = ResourceVersion("gateway.mulesoft.com/v1beta1")
  val monitoringV1Alpha1: ResourceVersion = ResourceVersion("monitoring.mulesoft.com/v1alpha1")
  val networkingV1Alpha1: ResourceVersion = ResourceVersion("networking.mulesoft.com/v1alpha1")
  // 'default' version is the status of the schema previous to the multi-versioning
  val default: ResourceVersion            = ResourceVersion("V1")
}
