package org.mulesoft.apb.project.internal.emitter.governance

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{Status, StatusModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.{emitBaseUnitField, emitObjectField, emitScalarField}
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}
import org.yaml.model.YType

class ProjectSummaryValidationStatusEmitter(status: Status) extends PartEmitter {

  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, status, StatusModel.Errors, `type` = YType.Int)
      emitScalarField(entryBuilder, status, StatusModel.Warning, `type` = YType.Int)
      emitScalarField(entryBuilder, status, StatusModel.Info, `type` = YType.Int)
    }
  }
  override def position(): Position = Position.ZERO
}

object ProjectSummaryValidationStatusEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryValidationStatusEmitter(Status(instance))
}
