package org.mulesoft.apb.project.client.platform.model

import amf.shapes.client.platform.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.{DynamicObject => InternalDynamicObject}
import org.mulesoft.apb.project.internal.model.{GraphAccessors => InternalGraphAccessors}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class DynamicObject private[apb] (private[apb] val _internal: InternalGraphAccessors) {

  def withDynamicProperty(key: String, value: String): DynamicObject =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalDynamicObject]

  def withDynamicProperty(key: String, value: Int): DynamicObject =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalDynamicObject]

  def withDynamicProperty(key: String, value: Boolean): DynamicObject =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalDynamicObject]

  def withDynamicProperty(key: String, value: Float): DynamicObject =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalDynamicObject]

  def withDynamicProperty(key: String, value: JsonLDObject): DynamicObject =
    _internal.withDynamicProperty(key, value).asInstanceOf[InternalDynamicObject]

}
