package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import org.mulesoft.apb.project.client.scala.extensions.environment.InstanceEnvironment
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitScalarField
import org.mulesoft.apb.project.internal.extensions.environment.InstanceEnvironmentModel
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryEnvironmentEmitter(environment: InstanceEnvironment) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, environment, InstanceEnvironmentModel.Id)
      emitScalarField(entryBuilder, environment, InstanceEnvironmentModel.Name)
      emitScalarField(entryBuilder, environment, InstanceEnvironmentModel.Type)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryEnvironmentEmitter {

  def apply(environment: InstanceEnvironment) = new ProjectSummaryEnvironmentEmitter(environment)
}
