package org.mulesoft.apb.project.internal.model

import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.internal.metamodel.Type.{Bool, DateTime, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, Type}
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{Anypoint, Api, Catalog, Core, Governance}
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel.Classifier

object ProjectDescriptorModel {
  val Main                  = Field(Str, Data + "main", doc("main"))
  val Name                  = Field(Str, Core + "name", doc("name"))
  val ApiVersion            = Field(Str, Api + "apiVersion", doc("apiVersion"))
  val OrganizationId        = Field(Str, Anypoint + "organizationId", doc("organizationId"))
  val OriginalFormatVersion = Field(Str, Data + "originalFormatVersion", doc("originalFormatVersion"))
  val BackwardsCompatible   = Field(Bool, Data + "backwardsCompatible", doc("backwardsCompatible"))
  val PublishWithRefFiles   = Field(Bool, Data + "publishWithRefFiles", doc("publishWithRefFiles"))
  val Description           = Field(Str, Data + "description", doc("description"))
  val DescriptorVersion     = Field(Str, Data + "descriptorVersion", doc("descriptorVersion"))
  val Metadata              = Field(JsonLDElementModel, Data + "metadata", doc("metadata"))
  val Dependencies =
    Field(Type.Array(JsonLDElementModel), Catalog + "dependency", doc("dependencies"))
  val Tags           = Field(Type.Array(Str), Catalog + "tags", doc("tags"))
  val ApiInstances   = Field(Type.Array(JsonLDElementModel), Api + "instance", doc("instances"))
  val ProjectId      = Field(Str, Data + "projectId", doc("projectId"))
  val Documentation  = Field(Type.Array(JsonLDElementModel), Api + "documentation", doc("documentation"))
  val Communities    = Field(Type.Array(JsonLDElementModel), Api + "community", doc("communities"))
  val GovernanceInfo = Field(JsonLDElementModel, Governance + "governance", doc("governance"))

  val ApiId       = Field(Str, Api + "apiId", doc("apiId"))
  val ProjectType = Field(Str, Data + "projectType", doc("projectType"))

  val ContactName  = Field(Str, Catalog + "contactName", doc("contactName"))
  val ContactEMail = Field(Str, Catalog + "contactEMail", doc("contactEMail"))

  val KeyValueTags: Field = Field(
      Type.Array(Str),
      Catalog + "keyValueTags",
      doc("keyValueTags")
  )

  val CreatedBy: Field = Field(
      Str,
      Anypoint + "userId",
      doc("createdBy")
  )

  val CreatedAt: Field = Field(
      DateTime,
      Core + "dateCreated",
      doc("createdAt")
  )

  val UpdatedAt: Field = Field(
      DateTime,
      Core + "dateModified",
      doc("updatedAt")
  )

  val SystemUpdatedAt: Field = Field(
      DateTime,
      Core + "systemUpdatedAt",
      doc("systemUpdatedAt")
  )

  val Status: Field = Field(
      Str,
      Catalog + "status",
      doc("status")
  )

  val TenantId: Field = Field(
      Str,
      Anypoint + "tenantId",
      doc("tenantId")
  )

  val MajorVersionComponent: Field = Field(
      Type.Int,
      Catalog + "majorVersionComponent",
      doc("majorVersionComponent")
  )

  val MinorVersionComponent: Field = Field(
      Type.Int,
      Catalog + "minorVersionComponent",
      doc("minorVersionComponent")
  )

  val PatchVersionComponent: Field = Field(
      Type.Int,
      Catalog + "patchVersionComponent",
      doc("patchVersionComponent")
  )

  val CustomFields: Field = Field(
      Type.Array(Str),
      Catalog + "customFields",
      doc("fields")
  )

  val Categories: Field = Field(
      Type.Array(Str),
      Catalog + "categories",
      doc("categories")
  )

  val TypeField: Field = Field(
      Str,
      Api + "type",
      doc("type")
  )

  val ProjectETag: Field = Field(
      Type.Str,
      Data + "projectETag",
      doc("projectETag")
  )

  val `type` = List(Data + "Descriptor")

  val fields = List(
      Main,
      Name,
      Classifier,
      ApiVersion,
      OrganizationId,
      OriginalFormatVersion,
      BackwardsCompatible,
      PublishWithRefFiles,
      Description,
      DescriptorVersion,
      Metadata,
      ProjectDependencyModel.GroupId,
      ProjectDependencyModel.AssetId,
      ProjectDependencyModel.Version,
      Tags,
      ProjectId,
      Dependencies,
      ApiInstances,
      KeyValueTags,
      CreatedBy,
      CreatedAt,
      UpdatedAt,
      Status,
      TenantId,
      MajorVersionComponent,
      MinorVersionComponent,
      PatchVersionComponent,
      CustomFields,
      Categories,
      TypeField,
      ApiId,
      ProjectType,
      Documentation,
      Communities
  )

  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}
