package org.mulesoft.apb.project.client.platform.model.project.management

import amf.aml.internal.convert.VocabulariesClientConverter.ClientOption
import amf.core.internal.convert.CoreClientConverters.InternalOptionOps
import amf.shapes.client.platform.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.convert.ShapeClientConverters.JsonLDObjectConverter
import org.mulesoft.apb.project.client.scala.model.project.management.{
  HasAnnotations => InternalHasAnnotations,
  HasLabels => InternalHasLabels,
  HasMetadata => InternalHasMetadata,
  HasName => InternalHasName,
  HasSpec => InternalHasSpec
}
import org.mulesoft.apb.project.internal.model.GraphAccessors.toJsonLDObject

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
trait HasName {
  private[apb] val internal: InternalHasName
  def name: String = internal.name

  def withName(name: String): this.type = {
    internal.withName(name)
    this
  }
}

@JSExportAll
trait HasAnnotations {
  private[apb] val internal: InternalHasAnnotations

  def getStringAnnotation(annotation: String): String   = internal.getAnnotation[String](annotation)
  def getIntAnnotation(annotation: String): Int         = internal.getAnnotation[Int](annotation)
  def getFloatAnnotation(annotation: String): Float     = internal.getAnnotation[Float](annotation)
  def getDoubleAnnotation(annotation: String): Double   = internal.getAnnotation[Double](annotation)
  def getBooleanAnnotation(annotation: String): Boolean = internal.getAnnotation[Boolean](annotation)

  def addAnnotation(annotation: String, value: String): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Int): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Float): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Double): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }

  def addAnnotation(annotation: String, value: Boolean): this.type = {
    internal.addAnnotation(annotation, value)
    this
  }
}

@JSExportAll
trait HasLabels {
  private[apb] val internal: InternalHasLabels
  def getStringLabel(label: String): String   = internal.getLabel[String](label)
  def getIntLabel(label: String): Int         = internal.getLabel[Int](label)
  def getFloatLabel(label: String): Float     = internal.getLabel[Float](label)
  def getDoubleLabel(label: String): Double   = internal.getLabel[Double](label)
  def getBooleanLabel(label: String): Boolean = internal.getLabel[Boolean](label)

  def addLabel(label: String, value: String): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Int): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Float): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Double): this.type = {
    internal.addLabel(label, value)
    this
  }

  def addLabel(label: String, value: Boolean): this.type = {
    internal.addLabel(label, value)
    this
  }
}

@JSExportAll
trait HasSpec {
  private[apb] val internal: InternalHasSpec

  def spec: JsonLDObject = JsonLDObjectConverter.asClient(toJsonLDObject(internal.spec))

  def specIfPresent: ClientOption[JsonLDObject] = internal.specIfPresent.map(toJsonLDObject).asClient
}

@JSExportAll
trait HasMetadata {
  private[apb] val internal: InternalHasMetadata

  def metadata: JsonLDObject = JsonLDObjectConverter.asClient(toJsonLDObject(internal.metadata))

  def metadataIfPresent: ClientOption[JsonLDObject] = internal.metadataIfPresent.map(toJsonLDObject).asClient
}
