package org.mulesoft.apb.project.client.scala.model.descriptor

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.internal.model.ProjectDescriptorModel.Dependencies
import org.mulesoft.apb.project.client.scala.model.descriptor.InstanceModel.{DefinedBy, GCL}
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}

object InstanceModel {

  val GCL       = Field(Str, Data + "gcl", doc("gcl"))
  val DefinedBy = Field(Str, Data + "definedBy", doc("definedBy"))

  val `type`              = List(Data + "APIInstance")
  def fields: List[Field] = List(GCL, DefinedBy)

  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

case class Instance private[apb] (override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = Instance
  override protected def fields: Fields = internal.fields

  def gcl: String               = get[StrField](GCL)
  def definedBy: Option[String] = get[StrField](DefinedBy)
  def dependencies: List[ProjectDependency] = get[Seq[JsonLDObject]](Dependencies)
    .map(ProjectDependency(_))
    .toList
  def withDefinedBy(schema: String): Instance = {
    internal.withProperty(DefinedBy, schema)
    this
  }

  def withDependencies(deps: Seq[ProjectDependency]): Instance = {
    internal.withObjPropertyCollection(Dependencies, deps.map(_.internal))
    this
  }
}

object Instance {
  def apply(gcl: String): Instance = Instance(
      JsonLDObject.empty(InstanceModel.entityModel, JsonPath.empty).set(GCL, gcl)
  )

}
