package org.mulesoft.apb.project.internal.jsonld
import amf.core.internal.metamodel.Field
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath

object JsonLDPathGenerator {
  def jsonLDObjectPath(jsonLDObject: JsonLDObject, fields: Field): JsonLDObject = {
    jsonLDObject.copy(path = JsonPath.apply(List(fields.doc.displayName)))
  }

  def jsonLDObjectSeqPath(seq: Seq[JsonLDObject], field: Field): Seq[JsonLDObject] = {
    val fieldName: String = field.doc.displayName
    seq.zipWithIndex.map { case (element, index) =>
      element.copy(path = JsonPath.apply(List(fieldName, index.toString)))
    }
  }
}
