package org.mulesoft.apb.project.client.scala.model.project.management

import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{ADDRESS, ROUTES, RichString, SPEC}
import org.mulesoft.apb.project.internal.model.GraphAccessors

case class Service(override private[apb] val internal: JsonLDObject)
    extends GraphAccessors
    with DynamicObject
    with HasName
    with HasSpec
    with HasLabels
    with HasAnnotations {

  def address: String = spec.getScalar[String](ADDRESS)

  def withAddress(address: String): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(ADDRESS, address)
    }
  }

  def routes: Seq[ServiceRoute] = {
    val routes = spec.getObjectArray(ROUTES)
    routes.zipWithIndex
      .map { case (routeDef, index) =>
        ServiceRoute(routeDef)(name, index)
      }
  }

  def withRoute(destinationPath: String): ServiceRoute = {
    val startingRoutes = routes
    val newRoute       = ServiceRoute(destinationPath)(name, startingRoutes.length)
    update(SPEC) { spec =>
      spec.withProperty(ROUTES, startingRoutes :+ newRoute)
    }
    newRoute
  }
  def withRoutes(routes: Seq[ServiceRoute]): this.type = {
    update(SPEC) { spec =>
      spec.withProperty(ROUTES, routes)
    }
  }
}
object Service {
  def apply(name: String, address: String): Service = {
    val model = SchemaIris.ADDRESS.toModel
    val init  = JsonLDObject.empty(model, model.path)
    Service(init)
      .withProperty("http://a.ml/vocabularies/core#apiVersion", Constants.apiVersion)
      .withProperty("http://a.ml/vocabularies/core#kind", Constants.serviceKind)
      .withName(name)
      .withAddress(address)
  }
}
