package org.mulesoft.apb.project.client.platform.descriptor

import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.platform.model.report.APBReport
import org.mulesoft.apb.project.client.scala.descriptor.{
  DescriptorHandler => InternalExchangeDescriptorHandler,
  DescriptorParseResult => InternalDescriptorParseResult
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class DescriptorParseResult private[apb] (override private[apb] val _internal: InternalDescriptorParseResult)
    extends APBReport(_internal) {
  def descriptor(): ProjectDescriptor = _internal.descriptor
}

@JSExportAll
@JSExportTopLevel("DescriptorHandler")
class DescriptorHandler {

  def parse(content: String): DescriptorParseResult =
    InternalExchangeDescriptorHandler().parse(content)

  def render(descriptor: ProjectDescriptor): String =
    InternalExchangeDescriptorHandler().render(descriptor._internal)

}
