package org.mulesoft.apb.project.client.scala

import amf.aml.client.scala.model.document.Dialect
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, ExtensionDependency, ManagementDependency, ParsedDependency, ProfileDependency}
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.model.report.{APBReport, APBResult}

trait DependencySet {

  def design(): Seq[DesignDependency]
  def validation(): Seq[ProfileDependency]
  def designExtension(): Seq[ExtensionDependency]
  def management(): Seq[ManagementDependency]
  def validationDialect(): Dialect
  def descriptor(): ProjectDescriptor
  def dependencyLoaders(): Map[String, ResourceLoader]
  def allDependencies(): Seq[ParsedDependency]
  def mainLoader(): ResourceLoader
}

case class DependencySetResult(dependencySet: DependencySet, override val results: Seq[APBResult])
    extends APBReport(results)
