package org.mulesoft.apb.project.client.scala.model

import amf.core.client.common.validation.ProfileName
import amf.core.client.scala.AMFResult
import amf.core.client.scala.model.document.{BaseUnit, ExternalFragment}
import amf.core.client.scala.model.domain.ExternalDomainElement
import amf.core.client.scala.validation.AMFValidationResult
import amf.core.internal.remote.Spec.AMF
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import org.mulesoft.apb.project.client.scala.model.project.Project
import org.mulesoft.apb.project.client.scala.model.report.{APBReport, APBResult}

abstract class BuildResult[+T](result: T, override val results: Seq[APBResult]) extends APBReport(results) {}

case class BaseUnitBuildResult(result: BaseUnit, override val results: Seq[APBResult])
    extends BuildResult[BaseUnit](result, results)

object BaseUnitBuildResult {
  private def profile(unit: BaseUnit) = ProfileName(spec(unit).id)
  private def spec(unit: BaseUnit)    = unit.sourceSpec.getOrElse(AMF)

  def apply(result: AMFResult): BaseUnitBuildResult = {
    BaseUnitBuildResult(result.baseUnit, result.results.map(APBResult.forContract))
  }

  def apply(unit: BaseUnit): BaseUnitBuildResult = {
    BaseUnitBuildResult(unit, Seq.empty)
  }

  def apply(error: AMFValidationResult): BaseUnitBuildResult = {
    val unit = ExternalFragment().withId("amf://error").withEncodes(ExternalDomainElement())
    BaseUnitBuildResult(unit, Seq(APBResult.forContract(error)))
  }
}

case class ProjectBuildResult(project: Project, override val results: Seq[APBResult])
    extends BuildResult[Project](project, results)

case class JsonLDInstanceDocumentBuildResult(result: JsonLDInstanceDocument, override val results: Seq[APBResult])
    extends BuildResult[JsonLDInstanceDocument](result, results)
