package org.mulesoft.apb.project.client.scala.helper

import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.DependencySetResult
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.internal.dependency.DependencySetParser

import scala.concurrent.Future

class APIProjectDependencyWrapper(
    private val fetcher: DependencyFetcher,
    private val loaders: List[ResourceLoader],
    private val _descriptor: DescriptorParseResult
) {
  def dependencies(): Future[DependencySetResult] = {
    new DependencySetParser(fetcher, loaders).build(_descriptor)
  }

  def descriptor(): DescriptorParseResult = _descriptor
}
