package org.mulesoft.apb.project.client.platform.model.descriptor.governance

import org.mulesoft.apb.project.client.platform.model.DynamicObject

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{Status => InternalStatus}

@JSExportAll
case class Status private[apb] (override private[apb] val _internal: InternalStatus) extends DynamicObject(_internal) {
  @JSExportTopLevel("Status")
  def this(errors: Int, warning: Int, info: Int) =
    this(InternalStatus(errors, warning, info))

  def errors(): Option[Int]  = _internal.errors
  def warning(): Option[Int] = _internal.warning
  def info(): Option[Int]    = _internal.info

  def withErrors(errors: Int): Status = {
    _internal.withErrors(errors)
    this
  }

  def withWarning(warning: Int): Status = {
    _internal.withWarning(warning)
    this
  }

  def withInfo(info: Int): Status = {
    _internal.withInfo(info)
    this
  }

}
