package org.mulesoft.apb.project.client.scala.helper

import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.DependencySetResult
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.internal.dependency.DependencySetParser
import org.mulesoft.apb.project.internal.environment.GavPathDependencyFetcher

import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.Future
import scala.util.Success

// This class is to emulate the behavior of the base functionality of APIProjectClient in apb-project module
class APIProjectDependencyWrapper(
    private val fetcher: DependencyFetcher,
    private val loaders: List[ResourceLoader],
    private val _descriptor: DescriptorParseResult
) {

  var _dependencies: Option[DependencySetResult] = None

  def dependencies(): Future[DependencySetResult] =
    memoizedDependencies { () =>
      new DependencySetParser(GavPathDependencyFetcher(fetcher), loaders).build(_descriptor)
    }

  def descriptor(): DescriptorParseResult = _descriptor

  private def memoizedDependencies(provider: () => Future[DependencySetResult]): Future[DependencySetResult] = {
    memoized(_dependencies, provider, cacheDependencies)
  }

  private def cacheDependencies(dependenciesResult: DependencySetResult): Unit = {
    this._dependencies = Some(dependenciesResult)
  }

  private def memoized[T](memoizedDependency: Option[T], provider: () => Future[T], memoizer: T => Unit): Future[T] = {
    memoizedDependency match {
      case Some(dependency) => Future.successful(dependency)
      case None =>
        provider().andThen { case Success(dependency) =>
          memoizer(dependency)
        }
    }
  }
}
