package org.mulesoft.apb.project.client.scala.model.descriptor.governance

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.{DateTime, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.ValidationModel.{AssetId, Group, Timestamp, Urn, entityModel}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Governance
import org.mulesoft.apb.project.internal.jsonld.JsonLDPathGenerator
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}
import org.mulesoft.common.time.SimpleDateTime

import scala.language.implicitConversions

class Validation(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = Validation

  override protected def fields: Fields = internal.fields

  private implicit def statusConversion(jsonLDObject: JsonLDObject): Status = Status.apply(jsonLDObject)

  def urn: String       = get[StrField](Urn)
  def assetId: String   = get[StrField](AssetId)
  def group: String     = get[StrField](Group)
  def version: String   = get[StrField](ValidationModel.Version)
  def status: Status    = get[JsonLDObject](ValidationModel.Status)
  def timestamp: String = get[StrField](Timestamp)

  def withUrn(urn: String): this.type = {
    internal.withProperty(Urn, urn)
    this
  }
  def withAssetId(assetId: String): this.type = {
    internal.withProperty(AssetId, assetId)
    this
  }

  def withGroup(group: String): this.type = {
    internal.withProperty(Group, group)
    this
  }

  def withVersion(version: String): this.type = {
    internal.withProperty(ValidationModel.Version, version)
    this
  }

  def withStatus(status: Status): this.type = {
    val jsonLDObject = JsonLDPathGenerator.jsonLDObjectPath(status.internal, ValidationModel.Status )
    internal.set(ValidationModel.Status, jsonLDObject)
    this
  }

  def withTimestamp(timestamp: SimpleDateTime): this.type = {
    internal.withDateTimeProperty(Timestamp, timestamp)
    this
  }

}

object Validation {
  def apply(
      urn: String,
      assetId: String,
      group: String,
      version: String,
      status: Status,
      timestamp: SimpleDateTime
  ): Validation =
    Validation
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withUrn(urn)
      .withAssetId(assetId)
      .withGroup(group)
      .withVersion(version)
      .withStatus(status)
      .withTimestamp(timestamp)

  private[apb] def apply(jsonLDObject: JsonLDObject): Validation = new Validation(jsonLDObject)
}

trait ValidationModel {
  val Urn: Field       = Field(Str, Governance + "urn", doc("urn"))
  val AssetId: Field   = Field(Str, Governance + "assetId", doc("assetId"))
  val Group: Field     = Field(Str, Governance + "group", doc("group"))
  val Version: Field   = Field(Str, Governance + "version", doc("version"))
  val Status: Field    = Field(JsonLDElementModel, Governance + "status", doc("status"))
  val Timestamp: Field = Field(DateTime, Governance + "timestamp", doc("timestamp"))

  def `type`: List[ValueType]        = List(Governance + "Validation")
  def fields: List[Field]            = List(Urn, AssetId, Group, Version, Status, Timestamp)
  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)

  protected def doc(name: String) = ModelDoc(displayName = name)
}
object ValidationModel extends ValidationModel
